/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.transactions;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.function.Supplier;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.impactdev.impactor.api.economy.currency.Currency;
import net.impactdev.impactor.api.economy.transactions.EconomyTransaction;
import net.impactdev.impactor.api.economy.transactions.details.EconomyResultType;
import net.impactdev.impactor.api.economy.transactions.details.EconomyTransactionType;
import net.impactdev.impactor.api.utility.builders.Builder;
import net.kyori.adventure.text.Component;

public record ImpactorEconomyTransaction(Account account, Currency currency, BigDecimal amount, EconomyTransactionType type, EconomyResultType result, Instant timestamp, Supplier<Component> message) implements EconomyTransaction
{
    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public static class TransactionBuilder
    implements Builder<ImpactorEconomyTransaction> {
        private Account account;
        private Currency currency;
        private BigDecimal amount;
        private EconomyTransactionType type;
        private EconomyResultType result;
        private Instant timestamp = Instant.now();
        private Supplier<Component> message;

        public TransactionBuilder account(Account account) {
            this.account = account;
            return this;
        }

        public TransactionBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public TransactionBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public TransactionBuilder type(EconomyTransactionType type) {
            this.type = type;
            return this;
        }

        public TransactionBuilder result(EconomyResultType result) {
            this.result = result;
            return this;
        }

        public TransactionBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TransactionBuilder message(Supplier<Component> message) {
            this.message = message;
            return this;
        }

        @Override
        public ImpactorEconomyTransaction build() {
            return new ImpactorEconomyTransaction(this.account, this.currency, this.amount, this.type, this.result, this.timestamp, this.message);
        }
    }
}

